<?php
// The source code packaged with this file is Free Software, Copyright (C) 2005 by
// Ricardo Galli <gallir at uib dot es>.
// It's licensed under the AFFERO GENERAL PUBLIC LICENSE unless stated otherwise.
// You can get copies of the licenses here:
// 		http://www.affero.org/oagpl.html
// AFFERO GENERAL PUBLIC LICENSE is also included in the file called "COPYING".

include_once('Smarty.class.php');
$main_smarty = new Smarty;

include('config.php');
include(mnminclude.'html1.php');
include(mnminclude.'ts.php');
include(mnminclude.'link.php');
include(mnminclude.'tags.php');
include(mnminclude.'user.php');
include(mnminclude.'smartyvariables.php');
include(mnminclude.'csrf.php');

// require user to log in
force_authentication();

// restrict access to god and admin only
$amIgod = 0;
$amIgod = $amIgod + checklevel('god');
$main_smarty->assign('amIgod', $amIgod);

$canIhaveAccess = 0;
$canIhaveAccess = $canIhaveAccess + checklevel('god');
$canIhaveAccess = $canIhaveAccess + checklevel('admin');

if($canIhaveAccess == 0){	
	$main_smarty->assign('tpl_center', $the_template . '/admin_templates/admin_access_denied');
	$main_smarty->display($the_template . '/pligg.tpl');		
	die();
}

// sidebar
$main_smarty = do_sidebar($main_smarty);

if($canIhaveAccess == 1)
{
	// sessions used to prevent CSRF
		$CSRF = new csrf();
	
	if (isset($_REQUEST["mode"]) && $_REQUEST["mode"] == "newuser"){
		$username=$db->escape(trim($_POST['username']));
		$password=$db->escape(trim($_POST['password']));
		$email=$db->escape(trim($_POST['email']));
		$level=$db->escape(trim($_POST['level']));
		$saltedpass=generateHash($password);
			if (!isset($username) || strlen($username) < 3) {
				$main_smarty->assign(usererror, $main_smarty->get_config_vars('PLIGG_Visual_Register_Error_UserTooShort'));			
			}
			elseif (!preg_match('/^[a-zA-Z0-9\-\.@]+$/', $username)) {
				$main_smarty->assign(usererror, $main_smarty->get_config_vars('PLIGG_Visual_Register_Error_UserInvalid'));
			}
			elseif (user_exists(trim($username)) ) {
				$main_smarty->assign(usererror, $main_smarty->get_config_vars('PLIGG_Visual_Register_Error_UserExists'));
			}
			elseif (!check_email(trim($email))) {
				$main_smarty->assign(usererror, $main_smarty->get_config_vars('PLIGG_Visual_Register_Error_BadEmail'));
			}
			elseif (email_exists(trim($email))) {
				$main_smarty->assign(usererror, $main_smarty->get_config_vars('PLIGG_Visual_Register_Error_EmailExists'));			
			}
			elseif (strlen($password) < 5 ) {
				$main_smarty->assign(usererror, $main_smarty->get_config_vars('PLIGG_Visual_Register_Error_FiveCharPass'));			
			}
			else {
				$db->query("INSERT INTO " . table_users . " (user_login, user_level, user_email, user_pass, user_date) VALUES ('$username', '$level', '$email', '$saltedpass', now())");
				header("Location: admin_users.php");
			}
	}

	if(isset($_GET["mode"])) {
		if ($_GET["mode"] == "view"){ // view single user

			// code to prevent CSRF
				if($_REQUEST["mode"] == 'view'){
					// we're visiting the page (or refreshing) and not actually doing anything
					// so recreate the session
					$CSRF->create('admin_users_resetpass', true, true);
				}
			// code to prevent CSRF
	
			$usersql = mysql_query('SELECT * FROM ' . table_users . ' where user_login="'.$_GET["user"].'"');
			$userdata = array();				
			while ($rows = mysql_fetch_array ($usersql, MYSQL_ASSOC)) array_push ($userdata, $rows);
		  
			foreach($userdata as $key => $val){
				$userdata[$key]['Avatar'] = get_avatar('large', "", $val['user_login'], $val['user_email']);
			}
		  
			$main_smarty->assign('userdata', $userdata);
			$linkcount=$db->get_var('SELECT count(*) FROM ' . table_links . ' where link_author="'.$userdata[0]['user_id'].'"');
			$main_smarty->assign('linkcount', $linkcount);
			$commentcount=$db->get_var('SELECT count(*) FROM ' . table_comments . ' where comment_user_id="'.$userdata[0]['user_id'].'"');
			$main_smarty->assign('commentcount', $commentcount);
			
			// breadcrumbs and page title
			$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
			$navwhere['link1'] = getmyurl('admin', '');
			$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
			$navwhere['link2'] = my_pligg_base . "/admin_users.php";
			$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_View_User');
			$main_smarty->assign('navbar_where', $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
			
			// pagename
			define('pagename', 'admin_users'); 
   			$main_smarty->assign('pagename', pagename);

			$user=new User();
			$user->username = $_GET["user"];
			if(!$user->read()) {
				echo "invalid user";
				die;
			}

			// module system hook
			$vars = '';
			check_actions('admin_users_view', $vars);

			// show the template
			$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_show_center');
			$main_smarty->display($the_template . '/pligg.tpl');
		}

		if ($_GET["mode"] == "edit"){ // edit user
			// code to prevent CSRF
				// doesn't matter if a token exists. if we're viewing this page, just
				// create a new one or replace the existing.
				$CSRF->create('admin_users_edit', true, true);
			// code to prevent CSRF		

			$usersql = mysql_query('SELECT * FROM ' . table_users . ' where user_login="'.$_GET["user"].'"');
			$userdata = array();
			while ($rows = mysql_fetch_array ($usersql, MYSQL_ASSOC)) array_push ($userdata, $rows);
			
			canIChangeUser($userdata[0]['user_level']);
			
			$main_smarty->assign('userdata', $userdata);
			$main_smarty->assign('levels', array('normal','god','admin'));

			// breadcrumbs and page title
			$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
			$navwhere['link1'] = getmyurl('admin', '');
			$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
			$navwhere['link2'] = my_pligg_base . "/admin_users.php";
			$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_Edit_User');
			$main_smarty->assign('navbar_where', $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
			
			// pagename
			define('pagename', 'admin_users'); 
			$main_smarty->assign('pagename', pagename);

			$user=new User();
			$user->username = $_GET["user"];
			if(!$user->read()) {
				echo "invalid user";
				die;
			}

			// module system hook
			$vars = '';
			check_actions('admin_users_edit', $vars);
	
			// show the template
			$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_edit_center');
			$main_smarty->display($the_template . '/pligg.tpl');
		}		
		
		if ($_GET["mode"] == $main_smarty->get_config_vars('PLIGG_Visual_Profile_Save')){ //save user info
			// code to prevent CSRF
				$CSRF->check_expired('admin_users_edit');
			// code to prevent CSRF

			if ($CSRF->check_valid($_GET['token'], 'admin_users_edit')){
				$user = $db->get_row('SELECT * FROM ' . table_users . ' where user_login="'.$_GET["user"].'"');
				
				canIChangeUser($user->user_level);
				
				if ($user) {
					$userdata=new User();
					$userdata->username = $user->user_login;
					if(!$userdata->read()) {
						echo "Error reading user data.";
						die;
					}
					
					// module system hook
					$vars = '';
					check_actions('admin_users_save', $vars);
					
					$userdata->username=trim($_GET["login"]);
					$userdata->level=trim($_GET["level"]);
					$userdata->email=trim($_GET["email"]);
					$userdata->store();
	
					// breadcrumbs and page title
					$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
					$navwhere['link1'] = getmyurl('admin', '');
					$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
					$navwhere['link2'] = my_pligg_base . "/admin_users.php";
					$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_Edit_User_Data_Saved');
					$main_smarty->assign('navbar_where', $navwhere);
					$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
					
					// pagename
					define('pagename', 'admin_users'); 
					$main_smarty->assign('pagename', pagename);
	
					header("Location: ".my_pligg_base."/admin_users.php?mode=view&user=".$_GET["login"]."");
					
				}
				else{showmyerror('userdoesntexist');}
			} else {
				$CSRF->show_invalid_error(1);
			}
		}

		if ($_GET["mode"] == "resetpass"){ // reset user password

			// code to prevent CSRF
				$CSRF->check_expired('admin_users_resetpass');
			// code to prevent CSRF
		
			if ($CSRF->check_valid($_GET['token'], 'admin_users_resetpass'))
			{
				$user= $db->get_row('SELECT * FROM ' . table_users . ' where user_login="'.$_GET["user"].'"');
				
				canIChangeUser($user->user_level);
				
				if ($user) {
					$db->query('UPDATE `' . table_users . '` SET `user_pass` = "033700e5a7759d0663e33b18d6ca0dc2b572c20031b575750" WHERE `user_login` = "'.$_GET["user"].'"');
	
					// breadcrumbs and page title
					$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
					$navwhere['link1'] = getmyurl('admin', '');
					$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
					$navwhere['link2'] = my_pligg_base . "/admin_users.php";
					$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_User_Reset_Pass');
					$main_smarty->assign('navbar_where', $navwhere);
					$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
					
					// pagename
					define('pagename', 'admin_users'); 
					$main_smarty->assign('pagename', pagename);
	
					// show the template
					$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_password_reset_center');
					$main_smarty->display($the_template . '/pligg.tpl');
				}
				else{showmyerror('userdoesntexist');}
			} else {
				$CSRF->show_invalid_error(1);
				// invalid token / timeout error
			}
		}

		if ($_GET["mode"] == "disable"){ // disable user

			// code to prevent CSRF
				// doesn't matter if a token exists. if we're viewing this page, just
				// create a new one or replace the existing.
				$CSRF->create('admin_users_disable', true, true);
			// code to prevent CSRF		
		
			if($_GET["user"] == "god"){
				echo "You can't disable this user";
			} else {
				$user= $db->get_row('SELECT * FROM ' . table_users . ' where user_login="'.$_GET["user"].'"');

				canIChangeUser($user->user_level); 
			
				if ($user) {
					
					// breadcrumbs and page title
					$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
					$navwhere['link1'] = getmyurl('admin', '');
					$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
					$navwhere['link2'] = my_pligg_base . "/admin_users.php";
					$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_User_Disable');
					$main_smarty->assign('navbar_where', $navwhere);
					$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
					
					$main_smarty->assign('user', $_GET["user"]);	
								
					// pagename
					define('pagename', 'admin_users'); 
					$main_smarty->assign('pagename', pagename);					
				
					// show the template
					$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_disable_step1_center');
					$main_smarty->display($the_template . '/pligg.tpl');
				} else {
					showmyerror('userdoesntexist');
				}
			}
		}

		if ($_GET["mode"] == "yesdisable"){ // diable user step 2
			// code to prevent CSRF
				$CSRF->check_expired('admin_users_disable');
			// code to prevent CSRF

			if ($CSRF->check_valid($_GET['token'], 'admin_users_disable'))
			{
				$user= $db->get_row('SELECT * FROM ' . table_users . ' where user_login="'.$_GET["user"].'"');
				
				canIChangeUser($user->user_level); 
				
				if ($user) {
					$db->query('UPDATE `' . table_users . '` SET `user_pass` = "63205e60098a9758101eeff9df0912ccaaca6fca3e50cdce3" WHERE `user_login` = "'.$_GET["user"].'"');
					$db->query('UPDATE `' . table_users . '` SET `user_email` = "blank@blank.com" WHERE `user_login` = "'.$_GET["user"].'"');
					
					// breadcrumbs and page titles
					$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
					$navwhere['link1'] = getmyurl('admin', '');
					$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
					$navwhere['link2'] = my_pligg_base . "/admin_users.php";
					$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_User_Disable_2');
					$main_smarty->assign('navbar_where', $navwhere);
					$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
					
					// pagename
					define('pagename', 'admin_users'); 
					$main_smarty->assign('pagename', pagename);
	
					header("Location: ".my_pligg_base."/admin_users.php");
				}
				else{showmyerror('userdoesntexist');}
			} else {
				// invalid token / timeout error
				$CSRF->show_invalid_error(2);
			}
		}

		if ($_GET["mode"] == "killspam"){ // killspam user
			// code to prevent CSRF
				// doesn't matter if a token exists. if we're viewing this page, just
				// create a new one or replace the existing.
				$CSRF->create('admin_users_killspam', true, true);
			// code to prevent CSRF		

			if($_GET["user"] == "god"){
		  		echo "You can't killspam this user";
			} else {
				$user= $db->get_row('SELECT * FROM ' . table_users . ' where user_login="'.$_GET["user"].'"');
			
				canIChangeUser($user->user_level);
				
				if ($user) {
	
					// breadcrumbs and page titles
					$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
					$navwhere['link1'] = getmyurl('admin', '');
					$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
					$navwhere['link2'] = my_pligg_base . "/admin_users.php";
					$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_User_Killspam');
					$main_smarty->assign('navbar_where', $navwhere);
					$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
					
					// misc smarty
					$main_smarty->assign('pagename', pagename);
					$main_smarty->assign('user', $_GET["user"]);
					$main_smarty->assign('id', $_GET["id"]);
					
					// pagename
					define('pagename', 'admin_users'); 
					$main_smarty->assign('pagename', pagename);
		
					// show the template
					$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_killspam_step1_center');
					$main_smarty->display($the_template . '/pligg.tpl');
				}
				else{showmyerror('userdoesntexist');}
			}
		}
		
		if ($_GET["mode"] == "yeskillspam"){ // killspam step 2
			// code to prevent CSRF
				$CSRF->check_expired('admin_users_killspam');
			// code to prevent CSRF
						
			if ($CSRF->check_valid($_GET['token'], 'admin_users_killspam'))
			{
				$user= $db->get_row('SELECT * FROM ' . table_users .' where user_login="'.$_GET["user"].'"');
				
				canIChangeUser($user->user_level);

				if ($user) {
					
					$db->query('UPDATE `' . table_users . '` SET `user_pass` = "63205e60098a9758101eeff9df0912ccaaca6fca3e50cdce3" WHERE `user_login` = "'.$_GET["user"].'"');
					$db->query('UPDATE `' . table_users . '` SET `user_email` = "blank@blank.com" WHERE `user_login` = "'.$_GET["user"].'"');
					$db->query('UPDATE `' . table_links . '` SET `link_status` = "discard" WHERE `link_author` = "'.$_GET["id"].'"');
					$db->query('DELETE FROM `' . table_comments . '` WHERE `comment_user_id` = "'.$_GET["id"].'"');
					
					// breadcrumbs and page title
					$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
					$navwhere['link1'] = getmyurl('admin', '');
					$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
					$navwhere['link2'] = my_pligg_base . "/admin_users.php";
					$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_User_Disable_2');
					$main_smarty->assign('navbar_where', $navwhere);
					$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
					
					// pagename
					define('pagename', 'admin_users'); 
					$main_smarty->assign('pagename', pagename);
	
					header("Location: ".my_pligg_base."/admin_users.php");
					
				}
				else{showmyerror('userdoesntexist');}
			} else {
				$CSRF->show_invalid_error(1);
			}
		}

		if ($_GET["mode"] == "viewlinks"){ // view users' links			
			global $offset;
			$offset=(get_current_page()-1)*25;
			
			$usersql = mysql_query("SELECT * FROM " . table_users . " where user_login='".$_GET['user']."'");
			$userdata = array();
		  while ($row = mysql_fetch_array ($usersql, MYSQL_ASSOC)) array_push ($userdata, $row);
			$main_smarty->assign('userdata', $userdata);
			$main_smarty->assign('user', $userdata[0][user_login]);

			if(isset($_POST["process"])) {
				switch ($_REQUEST["filter"]) {
					case 'Published':
						$filtered = mysql_query("SELECT * FROM " . table_links . " where link_author='".$userdata[0][user_id]."' AND link_status = 'published' ORDER BY link_date DESC");
						break;
				 	case 'Upcoming':
						$filtered = mysql_query("SELECT * FROM " . table_links . " where link_author='".$userdata[0][user_id]."' AND link_status = 'queued' ORDER BY link_date DESC");
						break;
				  case 'Discard':
						$filtered = mysql_query("SELECT * FROM " . table_links . " where link_author='".$userdata[0][user_id]."' AND link_status = 'discard' ORDER BY link_date DESC");
						break;
				  case 'All':
						$filtered = mysql_query("SELECT * FROM " . table_links . " where link_author='".$userdata[0][user_id]."' ORDER BY link_date DESC LIMIT $offset,25");
						$rows = $db->get_var("SELECT count(*) FROM " . table_links . " where link_author='".$userdata[0][user_id]."'");
						break;
				  case 'Search':
						$filtered = mysql_query("SELECT * FROM " . table_links . " WHERE link_author='".$userdata[0][user_id]."' AND link_title LIKE '%".$_POST["keyword"]."%' OR link_content LIKE '%".$_POST["keyword"]."%' ORDER BY link_date DESC");
						break;
			  }	
			}
			else {
			$filtered = mysql_query("SELECT * FROM " . table_links . " where link_author='".$userdata[0][user_id]."' ORDER BY link_date DESC LIMIT $offset,25");
		  	$rows = $db->get_var("SELECT count(*) FROM " . table_links . " where link_author='".$userdata[0][user_id]."'");
		  }			
			$links = array();
		  while ($row = mysql_fetch_array ($filtered, MYSQL_ASSOC)) array_push ($links, $row);
			$main_smarty->assign('links', $links);			
			
			// breadcrumbs and page title
			$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
			$navwhere['link1'] = getmyurl('admin', '');
			$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
			$navwhere['link2'] = my_pligg_base . "/admin_users.php";
			$navwhere['text3'] = $_GET["user"];
			$navwhere['link3'] = my_pligg_base."/admin_users.php?mode=view&user=".$_GET['user']."";
			$navwhere['text4'] = $main_smarty->get_config_vars('PLIGG_Visual_View_User_Sub_Links');
			$main_smarty->assign('navbar_where', $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
      
			// if admin changes the link status
			if ($_GET['action'] == "bulkmod") {
				if(isset($_POST['submit'])) {
					$comment = array();
					foreach ($_POST["link"] as $k => $v) {
						$comment[intval($k)] = $v;
					}
					foreach($comment as $key => $value) {
						if ($value == "publish") {
							$db->query('UPDATE `' . table_links . '` SET `link_status` = "published" WHERE `link_id` = "'.$key.'"');
						}
						elseif ($value == "queued") {
							$db->query('UPDATE `' . table_links . '` SET `link_status` = "queued" WHERE `link_id` = "'.$key.'"');
						}
						elseif ($value == "discard") {
							$db->query('UPDATE `' . table_links . '` SET `link_status` = "discard" WHERE `link_id` = "'.$key.'"');
						}
					}
		
					header("Location: ".my_pligg_base."/admin_users.php?mode=viewlinks&user=".$_POST['user']."");
				}
			}
      
			// pagename
			define('pagename', 'admin_users'); 
			$main_smarty->assign('pagename', pagename);
	 
	 		// show the template
			$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_view_links_center');
			$main_smarty->display($the_template . '/pligg.tpl');
		}

		if ($_GET["mode"] == "viewcomments"){ // view users' comments
			global $offset;		
			$offset=(get_current_page()-1)*25;
			
			$usersql = mysql_query("SELECT * FROM " . table_users . " where user_login='".$_GET['user']."'");
			$userdata = array();
			while ($row = mysql_fetch_array ($usersql, MYSQL_ASSOC)) array_push ($userdata, $row);
			$main_smarty->assign('userdata', $userdata);
			$main_smarty->assign('user', $userdata[0][user_login]);
			
			if ($_REQUEST["action"] == "search") {
				$usersql = mysql_query("SELECT * FROM " . table_comments . " where comment_user_id='".$userdata[0][user_id]."' AND comment_content LIKE '%".$_REQUEST['keyword']."%' ORDER BY comment_id DESC LIMIT $offset,25");	
			} else {
				$usersql = mysql_query("SELECT * FROM " . table_comments . " where comment_user_id='".$userdata[0][user_id]."' ORDER BY comment_id DESC LIMIT $offset,25");
			}
		
			$comments = array();
			while ($row = mysql_fetch_array ($usersql, MYSQL_ASSOC)) array_push ($comments, $row);
			$main_smarty->assign('comments', $comments);

			$rows = $db->get_var("SELECT count(*) FROM " . table_comments . " where comment_user_id='".$userdata[0][user_id]."'");

			// breadcrumbs and page title
			$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
			$navwhere['link1'] = getmyurl('admin', '');
			$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
			$navwhere['link2'] = my_pligg_base . "/admin_users.php";
			$navwhere['text3'] = $_GET["user"];;
			$navwhere['link3'] = my_pligg_base."/admin_users.php?mode=view&user=".$_GET['user']."";
			$navwhere['text4'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_View_Comments');
			$main_smarty->assign('navbar_where', $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
			
			// if admin deletes comment
			if ($_GET['action'] == "bulkmod") {
				if(isset($_POST['submit'])) {
					$comment = array();
					foreach ($_POST["comment"] as $k => $v) {
						$comment[intval($k)] = $v;
					}
					foreach($comment as $key => $value) {
						if ($value == "discard") {
							$db->query('DELETE FROM `' . table_comments . '` WHERE `comment_id` = "'.$key.'"');
							$db->query('DELETE FROM `' . table_comments . '` WHERE `comment_parent` = "'.$key.'"');
						}
					}
		
					header("Location: ".my_pligg_base."/admin_users.php?mode=viewcomments&user=".$_POST['user']."");
				}
			}
		
			
			// pagename
			define('pagename', 'admin_users'); 
			$main_smarty->assign('pagename', pagename);

			// show the template
			$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_view_comments_center');
			$main_smarty->display($the_template . '/pligg.tpl');
		}
		
		if ($_GET["mode"] == "search"){	// search users	
			global $offset, $page_size;
			$offset=(get_current_page()-1)*$page_size;
			$rows = $db->get_var("SELECT count(*) FROM " . table_users . " where user_login LIKE '%".$_GET["keyword"]."%' OR user_level LIKE '%".$_GET["keyword"]."%' OR user_email LIKE '%".$_GET["keyword"]."%' OR user_date LIKE '%".$_GET["keyword"]."%'");
		
			$searchsql = mysql_query("SELECT * FROM " . table_users . " where user_login LIKE '%".$_GET["keyword"]."%' OR user_level LIKE '%".$_GET["keyword"]."%' OR user_email LIKE '%".$_GET["keyword"]."%' OR user_date LIKE '%".$_GET["keyword"]."%' LIMIT $offset,$page_size");
			$userlist = array();
			
			while ($row = mysql_fetch_array ($searchsql, MYSQL_ASSOC)) array_push ($userlist, $row);
				foreach($userlist as $key => $val){
					$userlist[$key]['Avatar'] = get_avatar('large', "", $val['user_login'], $val['user_email']);
				}					
				$main_smarty->assign('userlist', $userlist);					
				
			// breadcrumbs and page title
			$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
			$navwhere['link1'] = getmyurl('admin', '');
			$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
			$navwhere['link2'] = my_pligg_base . "/admin_users.php";
			$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_Search'). $_GET["keyword"];
			$main_smarty->assign('navbar_where', $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
			
			// pagename	
			define('pagename', 'admin_users'); 
			$main_smarty->assign('pagename', pagename);

			// show the template
			$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_listall_center');
			$main_smarty->display($the_template . '/pligg.tpl');		
		
		}
	
	}
	else{ // No options are selected, so show the list of users.			
		global $offset, $top_users_size;			
		$offset=(get_current_page()-1)*$top_users_size;
		$rows = $db->get_var("SELECT count(*) FROM " .table_users."");
		
		$users = mysql_query("SELECT * FROM " . table_users . " ORDER BY `user_date` LIMIT $offset,$top_users_size");
		$userlist = array();
		
		while ($row = mysql_fetch_array ($users, MYSQL_ASSOC)) array_push ($userlist, $row);
		foreach($userlist as $key => $val){
			$userlist[$key]['Avatar'] = get_avatar('large', "", $val['user_login'], $val['user_email']);
		}
		
		$main_smarty->assign('userlist', $userlist);
		
		// breadcrumbs anf page title
		$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
		$navwhere['link1'] = getmyurl('admin', '');
		$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
		$navwhere['link2'] = my_pligg_base . "/admin_users.php";
		$main_smarty->assign('navbar_where', $navwhere);
		$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
		
		// pagename
		define('pagename', 'admin_users'); 
		$main_smarty->assign('pagename', pagename);

		// show the template
		$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_listall_center');
		$main_smarty->display($the_template . '/pligg.tpl');
	}
} else {
	echo 'not for you! go away!';
}		
		
function canIChangeUser($user_level) {
    global $amIgod, $main_smarty;
    
    //Don't want to let admins reset other admins or god
    $viewer = $main_smarty->get_template_vars('user_logged_in');
    $target = $_GET["user"];
    
    if ($viewer != $target && !$amIgod && (($user_level == 'god') || ($user_level == 'admin'))) {
        echo "Access denied";
        die;
    } 
}	

function showmyerror()
{
	global $main_smarty, $the_template;
	$main_smarty->assign('user', $_GET["user"]);

	// breadcrumbs and page title
	$navwhere['text1'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel');
	$navwhere['link1'] = getmyurl('admin', '');
	$navwhere['text2'] = $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel_1');
	$navwhere['link2'] = my_pligg_base . "/admin_users.php";
	$navwhere['text3'] = $main_smarty->get_config_vars('PLIGG_Visual_Breadcrumb_User_Does_Not_Exist');
	$main_smarty->assign('navbar_where', $navwhere);
	$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));
	
	// pagename
	define('pagename', 'admin_users'); 
	$main_smarty->assign('pagename', pagename);

	// show the template
	$main_smarty->assign('tpl_center', $the_template . '/admin_templates/user_doesnt_exist_center');
	$main_smarty->display($the_template . '/pligg.tpl');
}		
?>
